(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      9625,        307]*)
(*NotebookOutlinePosition[     10465,        334]*)
(*  CellTagsIndexPosition[     10421,        330]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
    \(\(\n (*\ For\ Chebyshev\ polynomials\ of\ firstkind, \ 
      the\ Chebyshev\ points\ on\ the\ interval\ \((0, 1)\)\ are\ obtained\ by
          \ taking\ \[Xi] = 2  x - 1\ *) \n\nChebyshevT[2, \[Xi]]\)\)], 
  "Input"],

Cell[BoxData[
    \(\(-1\) + 2\ \[Xi]\^2\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \( (*\ For\ the\ interval, \ \((0, 1)\)\ we\ have\ \[Xi] = 2\ x - 1\ *) 
      \)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ChebyshevT[2, 2\ x - 1]\)], "Input"],

Cell[BoxData[
    \(\(-1\) + 2\ \((\(-1\) + 2\ x)\)\^2\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(NSolve[ChebyshevT[2, 2\ x - 1] == \ 0, \ x]\)], "Input"],

Cell[BoxData[
    \({{x \[Rule] 0.146446609406726242`}, {x \[Rule] 0.853553390593273775`}}
      \)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(NSolve[ChebyshevT[3, 2\ x - 1] == \ 0, \ x]\)], "Input"],

Cell[BoxData[
    \({{x \[Rule] 0.0669872981077806795`}, {
        x \[Rule] 0.499999999999999822`}, {x \[Rule] 0.933012701892219631`}}
      \)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(NSolve[ChebyshevT[4, 2\ x - 1] == \ 0, \ x]\)], "Input"],

Cell[BoxData[
    \({{x \[Rule] 0.0380602337443566263`}, {
        x \[Rule] 0.308658283817455281`}, {x \[Rule] 0.691341716182543475`}, {
        x \[Rule] 0.961939766255644812`}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(NSolve[ChebyshevT[5, 2\ x - 1] == \ 0, \ x]\)], "Input"],

Cell[BoxData[
    \({{x \[Rule] 0.0244717418524232188`}, {x \[Rule] 0.20610737385376332`}, {
        x \[Rule] 0.500000000000001421`}, {x \[Rule] 0.793892626146231528`}, {
        x \[Rule] 0.975528258147580551`}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(NSolve[ChebyshevT[6, 2\ x - 1] == \ 0, \ x]\)], "Input"],

Cell[BoxData[
    \({{x \[Rule] 0.0170370868554658567`}, {
        x \[Rule] 0.146446609406726224`}, {x \[Rule] 0.370590477448738297`}, {
        x \[Rule] 0.62940952255127458`}, {x \[Rule] 0.853553390593233451`}, {
        x \[Rule] 0.982962913144561944`}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(NSolve[ChebyshevT[7, 2\ x - 1] == \ 0, \ x]\)], "Input"],

Cell[BoxData[
    \({{x \[Rule] 0.0125360439090881969`}, {
        x \[Rule] 0.109084258765985087`}, {x \[Rule] 0.283058130441220434`}, {
        x \[Rule] 0.500000000000005417`}, {x \[Rule] 0.71694186955875665`}, {
        x \[Rule] 0.890915741234058877`}, {x \[Rule] 0.987463956090885197`}}
      \)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(NSolve[ChebyshevT[8, 2\ x - 1] == \ 0, \ x]\)], "Input"],

Cell[BoxData[
    \({{x \[Rule] 0.00960735979838477582`}, {
        x \[Rule] 0.0842651938487273355`}, {
        x \[Rule] 0.222214883490200598`}, {x \[Rule] 0.402454838991917007`}, {
        x \[Rule] 0.597545161008159819`}, {x \[Rule] 0.777785116509540586`}, {
        x \[Rule] 0.915734806151648328`}, {x \[Rule] 0.990392640201421059`}}
      \)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(NSolve[ChebyshevT[9, 2\ x - 1] == \ 0, \ x]\)], "Input"],

Cell[BoxData[
    \({{x \[Rule] 0.00759612349389597163`}, {
        x \[Rule] 0.066987298107780635`}, {x \[Rule] 0.178606195156731502`}, {
        x \[Rule] 0.328989928337151749`}, {x \[Rule] 0.500000000000131361`}, {
        x \[Rule] 0.671010071662227058`}, {x \[Rule] 0.821393804844672104`}, {
        x \[Rule] 0.933012701890555895`}, {x \[Rule] 0.992403876506852888`}}
      \)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(NSolve[ChebyshevT[10, 2\ x - 1] == \ 0, \ x]\)], "Input"],

Cell[BoxData[
    \({{x \[Rule] 0.00615582970243113702`}, {
        x \[Rule] 0.0544967379058160705`}, {
        x \[Rule] 0.146446609406726491`}, {x \[Rule] 0.273004750130230977`}, {
        x \[Rule] 0.421782767479780762`}, {x \[Rule] 0.578217232521103774`}, {
        x \[Rule] 0.726995249864597514`}, {x \[Rule] 0.853553390608165685`}, {
        x \[Rule] 0.94550326207205817`}, {x \[Rule] 0.993844170309090735`}}
      \)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(\(\n (*\ For\ Chebyshev\ polynomials\ of\ second\ kind, \ 
      the\ Chebyshev\ points\ on\ the\ interval\ \((0, 1)\)\ are\ obtained\ by
          \ taking\ \[Xi] = 2  x - 1\ *) \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ChebyshevU[2, \[Xi]]\)], "Input"],

Cell[BoxData[
    \(\(-1\) + 4\ \[Xi]\^2\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(NSolve[ChebyshevU[2, 2\ x - 1] == \ 0, \ x]\)], "Input"],

Cell[BoxData[
    \({{x \[Rule] 0.25`}, {x \[Rule] 0.75`}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(NSolve[ChebyshevU[3, 2\ x - 1] == \ 0, \ x]\)], "Input"],

Cell[BoxData[
    \({{x \[Rule] 0.146446609406726242`}, {x \[Rule] 0.500000000000000088`}, {
        x \[Rule] 0.853553390593273597`}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(NSolve[ChebyshevU[4, 2\ x - 1] == \ 0, \ x]\)], "Input"],

Cell[BoxData[
    \({{x \[Rule] 0.0954915028125262743`}, {
        x \[Rule] 0.345491502812526629`}, {x \[Rule] 0.654508497187473281`}, {
        x \[Rule] 0.904508497187473636`}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(NSolve[ChebyshevU[5, 2\ x - 1] == \ 0, \ x]\)], "Input"],

Cell[BoxData[
    \({{x \[Rule] 0.0669872981077806795`}, {x \[Rule] 0.25`}, {
        x \[Rule] 0.499999999999999023`}, {x \[Rule] 0.750000000000004352`}, {
        x \[Rule] 0.933012701892215723`}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(NSolve[ChebyshevU[6, 2\ x - 1] == \ 0, \ x]\)], "Input"],

Cell[BoxData[
    \({{x \[Rule] 0.0495155660487904203`}, {
        x \[Rule] 0.188255099070633349`}, {x \[Rule] 0.388739533021842564`}, {
        x \[Rule] 0.611260466978159033`}, {x \[Rule] 0.811744900929360113`}, {
        x \[Rule] 0.950484433951214846`}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(NSolve[ChebyshevU[7, 2\ x - 1] == \ 0, \ x]\)], "Input"],

Cell[BoxData[
    \({{x \[Rule] 0.0380602337443566263`}, {
        x \[Rule] 0.146446609406726446`}, {x \[Rule] 0.30865828381745155`}, {
        x \[Rule] 0.500000000000032951`}, {x \[Rule] 0.691341716182426591`}, {
        x \[Rule] 0.853553390593454786`}, {x \[Rule] 0.96193976625555102`}}
      \)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(NSolve[ChebyshevU[8, 2\ x - 1] == \ 0, \ x]\)], "Input"],

Cell[BoxData[
    \({{x \[Rule] 0.0301536896070458082`}, {x \[Rule] 0.11697777844051107`}, {
        x \[Rule] 0.249999999999999023`}, {x \[Rule] 0.413175911166536558`}, {
        x \[Rule] 0.586824088833506607`}, {x \[Rule] 0.749999999999773692`}, {
        x \[Rule] 0.883022221559896181`}, {x \[Rule] 0.969846310392730437`}}
      \)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(NSolve[ChebyshevU[9, 2\ x - 1] == \ 0, \ x]\)], "Input"],

Cell[BoxData[
    \({{x \[Rule] 0.0244717418524232099`}, {
        x \[Rule] 0.0954915028125263276`}, {
        x \[Rule] 0.206107373853763498`}, {x \[Rule] 0.345491502812530804`}, {
        x \[Rule] 0.499999999999967226`}, {x \[Rule] 0.654508497187562543`}, {
        x \[Rule] 0.793892626146105939`}, {x \[Rule] 0.904508497187590343`}, {
        x \[Rule] 0.97552825814753028`}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(NSolve[ChebyshevU[10, 2\ x - 1] == \ 0, \ x]\)], "Input"],

Cell[BoxData[
    \({{x \[Rule] 0.0202535131927513001`}, {
        x \[Rule] 0.0793732335844095171`}, {
        x \[Rule] 0.172569633027357216`}, {x \[Rule] 0.292292493499086702`}, {
        x \[Rule] 0.428842580862918243`}, {x \[Rule] 0.57115741913920095`}, {
        x \[Rule] 0.707707506493217231`}, {x \[Rule] 0.827430366985637633`}, {
        x \[Rule] 0.920626766403776564`}, {x \[Rule] 0.979746486811644068`}}
      \)], "Output"]
}, Open  ]]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 832}, {0, 604}},
WindowSize->{520, 509},
WindowMargins->{{28, Automatic}, {30, Automatic}},
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@0000000000000006P801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 238, 4, 107, "Input"],
Cell[1972, 57, 54, 1, 28, "Output"]
}, Open  ]],
Cell[2041, 61, 110, 2, 27, "Input"],

Cell[CellGroupData[{
Cell[2176, 67, 56, 1, 27, "Input"],
Cell[2235, 70, 68, 1, 28, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2340, 76, 76, 1, 27, "Input"],
Cell[2419, 79, 111, 2, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2567, 86, 76, 1, 27, "Input"],
Cell[2646, 89, 156, 3, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2839, 97, 76, 1, 27, "Input"],
Cell[2918, 100, 193, 3, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3148, 108, 76, 1, 27, "Input"],
Cell[3227, 111, 227, 3, 41, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3491, 119, 76, 1, 27, "Input"],
Cell[3570, 122, 271, 4, 41, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3878, 131, 76, 1, 27, "Input"],
Cell[3957, 134, 313, 5, 41, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4307, 144, 76, 1, 27, "Input"],
Cell[4386, 147, 360, 6, 56, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4783, 158, 76, 1, 27, "Input"],
Cell[4862, 161, 394, 6, 56, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5293, 172, 77, 1, 27, "Input"],
Cell[5373, 175, 438, 7, 56, "Output"]
}, Open  ]],
Cell[5826, 185, 214, 3, 91, "Input"],

Cell[CellGroupData[{
Cell[6065, 192, 53, 1, 27, "Input"],
Cell[6121, 195, 54, 1, 28, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6212, 201, 76, 1, 27, "Input"],
Cell[6291, 204, 72, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6400, 210, 76, 1, 27, "Input"],
Cell[6479, 213, 148, 2, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6664, 220, 76, 1, 27, "Input"],
Cell[6743, 223, 193, 3, 41, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6973, 231, 76, 1, 27, "Input"],
Cell[7052, 234, 212, 3, 41, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7301, 242, 76, 1, 27, "Input"],
Cell[7380, 245, 272, 4, 41, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7689, 254, 76, 1, 27, "Input"],
Cell[7768, 257, 312, 5, 41, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8117, 267, 76, 1, 27, "Input"],
Cell[8196, 270, 348, 5, 41, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8581, 280, 76, 1, 27, "Input"],
Cell[8660, 283, 395, 6, 56, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[9092, 294, 77, 1, 27, "Input"],
Cell[9172, 297, 437, 7, 56, "Output"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

